/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi.internal;

import android.os.AsyncTask;
import com.google.gson.Gson;
import com.pddstudio.linodeapi.config.LinodePreferences;
import com.pddstudio.linodeapi.enums.ValidationType;
import com.pddstudio.linodeapi.interfaces.LinodeValidationCallback;
import com.pddstudio.linodeapi.models.TestEcho;
import com.pddstudio.linodeapi.models.UserInfo;
import com.pddstudio.linodeapi.models.data.ErrorCodeData;
import com.pddstudio.linodeapi.models.data.TestEchoData;
import com.pddstudio.linodeapi.models.data.UserApiKeyData;
import com.pddstudio.linodeapi.utils.Logger;
import com.pddstudio.linodeapi.utils.UrlUtils;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ApiAccessValidation {
    private final LinodeValidationCallback linodeValidationCallback;
    private final LinodePreferences linodePreferences;

    public ApiAccessValidation(LinodeValidationCallback linodeValidationCallback, LinodePreferences linodePreferences) {
        this.linodeValidationCallback = linodeValidationCallback;
        this.linodePreferences = linodePreferences;
    }

    public void validate() {
        new ValidationTask().execute(new Void[0]);
    }

    private class ValidationTask
    extends AsyncTask<Void, Void, ValidationType> {
        ValidationTask() {
        }

        public void onPreExecute() {
            ApiAccessValidation.this.linodeValidationCallback.onValidationStart();
        }

        protected ValidationType doInBackground(Void ... params) {
            block8: {
                Gson gson = new Gson();
                OkHttpClient okHttpClient = new OkHttpClient();
                try {
                    if (ApiAccessValidation.this.linodePreferences.isApiKeyAvailable()) {
                        TestEcho responseData;
                        String apiCallUrl = UrlUtils.getEchoUrl(ApiAccessValidation.this.linodePreferences.getCurrentApiKey());
                        Logger.log((Object)this, "Building and executing request for given URL: " + apiCallUrl);
                        Request request = new Request.Builder().url(apiCallUrl).build();
                        Response response = okHttpClient.newCall(request).execute();
                        if (!response.isSuccessful()) {
                            this.cancel(true);
                        }
                        if ((responseData = (TestEcho)gson.fromJson(response.body().charStream(), TestEcho.class)) == null) break block8;
                        if (responseData.getResponseData() != null && ((TestEchoData)responseData.getResponseData()).getApiEcho() != null) {
                            if (((TestEchoData)responseData.getResponseData()).getApiEcho().toLowerCase().equals("received".toLowerCase())) {
                                return ValidationType.SUCCESS;
                            }
                            break block8;
                        }
                        if (responseData.getErrorCodeArray().length > 0) {
                            for (ErrorCodeData errorCodeData : responseData.getErrorCodeArray()) {
                                if (errorCodeData.getErrorCode() != 4) continue;
                                Logger.log((Object)this, "ApiAccessValidation: " + errorCodeData.getErrorMessage() + " [Trying to request a new API Key now]");
                                return this.validateCredentials();
                            }
                            break block8;
                        }
                        return ValidationType.UNKNOWN_ERROR;
                    }
                    return this.validateCredentials();
                }
                catch (IOException io) {
                    Logger.log((Object)this, "API call execution failed! Reason:\n" + io.getMessage());
                    this.cancel(true);
                }
            }
            return null;
        }

        private ValidationType validateCredentials() throws IOException {
            if (ApiAccessValidation.this.linodePreferences.isUsernameAvailable() && ApiAccessValidation.this.linodePreferences.isPasswordAvailable()) {
                UserInfo userInfo;
                Gson gson = new Gson();
                OkHttpClient okHttpClient = new OkHttpClient();
                String requestUrl = "https://api.linode.com/?api_action=user.getapikey&username=" + ApiAccessValidation.this.linodePreferences.getCurrentUsername() + "&password=" + ApiAccessValidation.this.linodePreferences.getCurrentPassword() + "&expires=0&label=LINODE_ANDROID_API_KEY";
                Request request = new Request.Builder().url(requestUrl).build();
                Response response = okHttpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    this.cancel(true);
                }
                if ((userInfo = (UserInfo)gson.fromJson(response.body().charStream(), UserInfo.class)) != null) {
                    if (userInfo.getErrorCodeArray().length > 0) {
                        for (ErrorCodeData errorCodeData : userInfo.getErrorCodeArray()) {
                            Logger.log((Object)this, "Error Code : " + errorCodeData.getErrorCode() + " Error Message: " + errorCodeData.getErrorMessage());
                            if (errorCodeData.getErrorCode() != 44) continue;
                            return ValidationType.MISSING_TOKEN;
                        }
                        return ValidationType.UNKNOWN_ERROR;
                    }
                    String apiKey = ((UserApiKeyData)userInfo.getResponseData()).getApiKey();
                    Logger.log((Object)this, "API-Key received successfully [" + apiKey + "]");
                    ApiAccessValidation.this.linodePreferences.setCurrentApiKey(apiKey);
                    return ValidationType.SUCCESS;
                }
                return ValidationType.UNKNOWN_ERROR;
            }
            return ValidationType.MISSING_CREDENTIALS;
        }

        protected void onCancelled() {
            ApiAccessValidation.this.linodeValidationCallback.onValidationFailed();
        }

        public void onPostExecute(ValidationType validationType) {
            Logger.log((Object)this, "Task finished. Returning Type: " + validationType.name());
            ApiAccessValidation.this.linodeValidationCallback.onValidationFinished(validationType);
        }
    }
}

