/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.linodeapi.utils;

import android.content.Context;
import com.pddstudio.linodeapi.config.LinodePreferences;
import com.pddstudio.linodeapi.interfaces.ApiAction;

public final class UrlBuilder {
    private final String baseUrl;
    private final String apiKey;
    private final String apiAction;
    private final StringBuilder customParams;

    public UrlBuilder(Context context, ApiAction apiAction) {
        this.baseUrl = "https://api.linode.com/";
        this.apiKey = LinodePreferences.getInstance(context).getCurrentApiKey();
        this.apiAction = apiAction.getApiCommand();
        this.customParams = new StringBuilder();
    }

    public UrlBuilder appendCustom(String action, String value) {
        this.customParams.append("&").append(action).append("=").append(value);
        return this;
    }

    public String build() {
        return this.baseUrl + "?api_key=" + this.apiKey + "&api_action=" + this.apiAction;
    }

    public String buildWithCustomParams() {
        String url = this.build();
        if (!this.customParams.toString().isEmpty()) {
            url = url + this.customParams.toString();
        }
        return url;
    }
}

