/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.talking;

import android.content.Context;
import android.speech.SpeechRecognizer;
import com.pddstudio.talking.exceptions.TalkNotInitializedException;
import com.pddstudio.talking.model.RecognitionModel;
import com.pddstudio.talking.model.SpeechObject;
import java.util.LinkedList;
import java.util.List;

public final class Talk {
    private static Talk talk;
    private final Context context;
    private final Callback callback;
    private final List<SpeechObject> speechObjects;
    private final SpeechRecognizer speechRecognizer;
    private RecognitionModel recognitionModel;

    private Talk(Context context, Callback callback) {
        this.context = context;
        this.callback = callback;
        this.speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)context);
        this.speechObjects = new LinkedList<SpeechObject>();
    }

    public static void init(Context context, Callback callback) {
        if (talk == null) {
            talk = new Talk(context, callback);
        }
    }

    public static Talk getInstance() {
        if (talk == null) {
            throw new TalkNotInitializedException();
        }
        return talk;
    }

    public void addSpeechObjects(SpeechObject ... speechObjects) {
        for (SpeechObject speechObject : speechObjects) {
            this.speechObjects.add(speechObject);
        }
    }

    public void startListening() {
        this.recognitionModel = new RecognitionModel(this.callback, this.speechRecognizer, this.speechObjects);
        this.recognitionModel.startListening();
    }

    public void stopListening() {
        if (this.recognitionModel != null) {
            this.recognitionModel.stopListening();
            this.recognitionModel = null;
        }
    }

    public static interface Callback {
        public void onStartListening();

        public void onRmsChanged(float var1);

        public void onFailedListening(int var1);

        public void onFinishedListening(SpeechObject var1);
    }
}

