/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.talking.model;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.util.Log;
import com.pddstudio.talking.Talk;
import com.pddstudio.talking.model.SpeechObject;
import java.util.ArrayList;
import java.util.List;

public class RecognitionModel
implements RecognitionListener {
    private static final String LOG_TAG = "RecognitionModel";
    final Talk.Callback tk;
    final SpeechRecognizer speechRecognizer;
    final List<SpeechObject> speechObjects;

    public RecognitionModel(Talk.Callback callback, SpeechRecognizer speechRecognizer, List<SpeechObject> speechObjectList) {
        this.tk = callback;
        this.speechRecognizer = speechRecognizer;
        this.speechObjects = speechObjectList;
        this.speechRecognizer.setRecognitionListener((RecognitionListener)this);
    }

    public void startListening() {
        Intent recognizerIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
        recognizerIntent.putExtra("android.speech.extra.LANGUAGE", "en-US");
        if (Build.VERSION.SDK_INT >= 23) {
            recognizerIntent.putExtra("android.speech.extra.PREFER_OFFLINE", true);
        }
        recognizerIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        recognizerIntent.putExtra("android.speech.extra.PARTIAL_RESULTS", true);
        this.speechRecognizer.startListening(recognizerIntent);
        this.tk.onStartListening();
        Log.d((String)LOG_TAG, (String)"startListening()");
    }

    public void stopListening() {
        this.speechRecognizer.destroy();
    }

    public void onReadyForSpeech(Bundle params) {
    }

    public void onBeginningOfSpeech() {
    }

    public void onRmsChanged(float rmsdB) {
        this.tk.onRmsChanged(rmsdB);
    }

    public void onBufferReceived(byte[] buffer) {
    }

    public void onEndOfSpeech() {
    }

    public void onError(int error) {
        this.tk.onFailedListening(error);
    }

    public void onResults(Bundle results) {
        boolean commandReceived = false;
        Log.d((String)LOG_TAG, (String)"onResults()");
        ArrayList resultsList = results.getStringArrayList("results_recognition");
        if (resultsList != null && !resultsList.isEmpty()) {
            for (String s : resultsList) {
                Log.d((String)LOG_TAG, (String)("Result: " + s));
                for (SpeechObject speechObject : this.speechObjects) {
                    if (!s.toLowerCase().contains(speechObject.getVoiceString().toLowerCase())) continue;
                    this.tk.onFinishedListening(speechObject);
                    commandReceived = true;
                }
            }
            if (!commandReceived) {
                this.tk.onFailedListening(42);
            }
        } else {
            this.tk.onFailedListening(42);
        }
    }

    public void onPartialResults(Bundle partialResults) {
    }

    public void onEvent(int eventType, Bundle params) {
    }
}

