/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.urlshortener;

import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.pddstudio.urlshortener.Utils;
import com.pddstudio.urlshortener.async.AsyncLoader;
import com.pddstudio.urlshortener.async.AsyncLoader2;
import com.pddstudio.urlshortener.model.RequestModel;
import com.pddstudio.urlshortener.model.ResponseModel;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class URLShortener {
    public static String shortUrl(String longUrl) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Gson gson = new Gson();
        RequestModel requestModel = new RequestModel(longUrl);
        String postBody = gson.toJson((Object)requestModel);
        Request request = new Request.Builder().url("https://www.googleapis.com/urlshortener/v1/url?key=AIzaSyAHp3aO2sNnaZwTOEdaXZmf-kaZ3ohI4xU").post(RequestBody.create((MediaType)Utils.MEDIA_TYPE, (String)postBody)).build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                return null;
            }
            String responseStr = response.body().string();
            ResponseModel responseModel = (ResponseModel)gson.fromJson(responseStr, ResponseModel.class);
            return responseModel.getId();
        }
        catch (IOException io) {
            io.printStackTrace();
            return null;
        }
    }

    public static void shortUrl(String longUrl, LoadingCallback loadingCallback) {
        new AsyncLoader(longUrl, loadingCallback).execute(new Void[0]);
    }

    public static void longUrl(String shortUrl, LoadingCallback loadingCallback) {
        new AsyncLoader2(shortUrl, loadingCallback).execute(new Void[0]);
    }

    public static interface LoadingCallback {
        public void startedLoading();

        public void finishedLoading(@Nullable String var1);
    }
}

