/*
 * Decompiled with CFR 0.152.
 */
package com.pddstudio.urlshortener.async;

import android.os.AsyncTask;
import com.google.gson.Gson;
import com.pddstudio.urlshortener.URLShortener;
import com.pddstudio.urlshortener.Utils;
import com.pddstudio.urlshortener.model.RequestModel;
import com.pddstudio.urlshortener.model.ResponseModel;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AsyncLoader
extends AsyncTask<Void, Void, String> {
    final URLShortener.LoadingCallback loadingCallback;
    final String longUrl;

    public AsyncLoader(String longUrl, URLShortener.LoadingCallback loadingCallback) {
        this.loadingCallback = loadingCallback;
        this.longUrl = longUrl;
    }

    public void onPreExecute() {
        this.loadingCallback.startedLoading();
    }

    protected String doInBackground(Void ... params) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Gson gson = new Gson();
        RequestModel requestModel = new RequestModel(this.longUrl);
        String postBody = gson.toJson((Object)requestModel);
        Request request = new Request.Builder().url("https://www.googleapis.com/urlshortener/v1/url?key=AIzaSyAHp3aO2sNnaZwTOEdaXZmf-kaZ3ohI4xU").post(RequestBody.create((MediaType)Utils.MEDIA_TYPE, (String)postBody)).build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                return null;
            }
            String responseStr = response.body().string();
            ResponseModel responseModel = (ResponseModel)gson.fromJson(responseStr, ResponseModel.class);
            return responseModel.getId();
        }
        catch (IOException io) {
            io.printStackTrace();
            return null;
        }
    }

    public void onPostExecute(String shortUrl) {
        this.loadingCallback.finishedLoading(shortUrl);
    }
}

