/****************************************************************************
 *
 * File:            ConsumptionData.java
 *
 * Description:     PDFTOOLS ConsumptionData Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * 
 * This class contains page-based license usage data.
 */
public class ConsumptionData extends NativeObject 
{
    protected ConsumptionData(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ConsumptionData createDynamicObject(long handle)
    {
        return new ConsumptionData(handle);
    }




     /**
     * Denotes the number of pages left to consume before entering the over-consumption state.
     * When this value reaches zero, the SDK can still be used as long as {@link ConsumptionData#getOverconsumption } is positive.
     */
    public int getRemainingPages()
    {
        int retVal = getRemainingPagesNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * Denotes the number of pages left to consume in the over-consumption state.
     * The over-consumption state begins after all {@link ConsumptionData#getRemainingPages } are consumed.
     * When this value reaches zero, a license error is thrown for every attempt to use the SDK.
     */
    public int getOverconsumption()
    {
        int retVal = getOverconsumptionNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }




    private native int getRemainingPagesNative(long handle);
    private native int getOverconsumptionNative(long handle);

}

