/****************************************************************************
 *
 * File:            LicenseInfo.java
 *
 * Description:     PDFTOOLS LicenseInfo Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * 
 * This class contains license information.
 */
public class LicenseInfo extends NativeObject 
{
    protected LicenseInfo(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static LicenseInfo createDynamicObject(long handle)
    {
        return new LicenseInfo(handle);
    }




     /**
     * Denotes whether the license is valid.
     */
    public boolean getIsValid()
    {
        boolean retVal = getIsValidNative(getHandle());
        if (!retVal)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * The license expiration date.
     */
    public OffsetDateTime getExpirationDate()
    {
        OffsetDateTime retVal = getExpirationDateNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * This property exists only for page-based licenses. It is {@code null} for all other licenses.
     */
    public com.pdftools.ConsumptionData getConsumptionData()
    {
        long retHandle = getConsumptionDataNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
            return null;
        }
        return com.pdftools.ConsumptionData.createDynamicObject(retHandle);

    }




    private native boolean getIsValidNative(long handle);
    private native OffsetDateTime getExpirationDateNative(long handle);
    private native long getConsumptionDataNative(long handle);

}

