/****************************************************************************
 *
 * File:            HashAlgorithm.java
 *
 * Description:     HashAlgorithm Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.crypto;

/**
 * 
 */
public enum HashAlgorithm  
{
    /**
     * <h1>MD5</h1>
     * This algorithm is considered broken and therefore strongly discouraged by the cryptographic community.
     */
    MD5(1),
    /**
     * <h1>RIPEMD-160</h1>
     */
    RIPE_MD160(2),
    /**
     * <h1>SHA-1</h1>
     * This algorithm is considered broken and therefore strongly discouraged by the cryptographic community.
     */
    SHA1(3),
    /**
     * <h1>SHA-256</h1>
     */
    SHA256(4),
    /**
     * <h1>SHA-384</h1>
     */
    SHA384(5),
    /**
     * <h1>SHA-512</h1>
     */
    SHA512(6),
    /**
     * <h1>SHA3-256</h1>
     * {@code SHA3-256} is a new hashing algorithm and may not be supported by some applications.
     */
    SHA3_256(7),
    /**
     * <h1>SHA3-384</h1>
     * {@code SHA3-384} is a new hashing algorithm and may not be supported by some applications.
     */
    SHA3_384(8),
    /**
     * <h1>SHA3-512</h1>
     * {@code SHA3-512} is a new hashing algorithm and may not be supported by some applications.
     */
    SHA3_512(9);

    HashAlgorithm(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static HashAlgorithm fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return MD5;
            case 2: return RIPE_MD160;
            case 3: return SHA1;
            case 4: return SHA256;
            case 5: return SHA384;
            case 6: return SHA512;
            case 7: return SHA3_256;
            case 8: return SHA3_384;
            case 9: return SHA3_512;
        }
        throw new IllegalArgumentException("Unknown value for HashAlgorithm: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
