/****************************************************************************
 *
 * File:            SignatureAlgorithm.java
 *
 * Description:     SignatureAlgorithm Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.crypto;

/**
 * <h1>Cryptographic signature algorithm</h1>
 */
public enum SignatureAlgorithm  
{
    /**
     * <h1>RSA with PKCS#1 v1.5</h1>
     * This is the RSA with PKCS#1 v1.5 algorithm which is widely supported by cryptographic providers.
     */
    RSA_RSA(1),
    /**
     * <h1>RSA with SSA-PSS (PKCS#1 v2.1)</h1>
     * This algorithm is generally recommended because it is considered a more secure alternative to {@code RSA_RSA}.
     * However, it is not supported by all cryptographic providers.
     */
    RSA_SSA_PSS(2),
    /**
     * <h1>Elliptic Curve Digital Signature Algorithm</h1>
     * This algorithm is generally recommended for new applications.
     * However, it is not supported by all cryptographic providers.
     */
    ECDSA(3);

    SignatureAlgorithm(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static SignatureAlgorithm fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return RSA_RSA;
            case 2: return RSA_SSA_PSS;
            case 3: return ECDSA;
        }
        throw new IllegalArgumentException("Unknown value for SignatureAlgorithm: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
