/****************************************************************************
 *
 * File:            SignatureFormat.java
 *
 * Description:     SignatureFormat Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.crypto;

/**
 * 
 */
public enum SignatureFormat  
{
    /**
     * <h1>Legacy PAdES Basic signature (PDF 1.6)</h1>
     * Legacy PAdES Basic signature specified by ETSI TS 102 778, Part 2.
     * This type can be used for document signatures and certification (MDP) signatures.
     */
    ADBE_PKCS7_DETACHED(1),
    /**
     * <h1>PAdES signature (PDF 2.0)</h1>
     * PAdES signature as specified by European Standard ETSI EN 319 142.
     * This type can be used for document signatures and certification (MDP) signatures.
     */
    ETSI_CADES_DETACHED(2);

    SignatureFormat(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static SignatureFormat fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return ADBE_PKCS7_DETACHED;
            case 2: return ETSI_CADES_DETACHED;
        }
        throw new IllegalArgumentException("Unknown value for SignatureFormat: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
