/****************************************************************************
 *
 * File:            CertificateList.java
 *
 * Description:     PDFTOOLS CertificateList Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.crypto.providers;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
/**
 * 
 */
public class CertificateList extends NativeObject implements List<com.pdftools.crypto.providers.Certificate> 
{
    protected CertificateList(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static CertificateList createDynamicObject(long handle)
    {
        return new CertificateList(handle);
    }





    /////////////////////////////////////////////////////
    // List implementation
    /////////////////////////////////////////////////////

    /**
     * Not supported.
     */
    @Override
    public boolean addAll(Collection<? extends com.pdftools.crypto.providers.Certificate> elements)
    {
        if (elements == null)
            throw new NullPointerException("'elements'");
        if (elements.isEmpty())
            return false;

        for (com.pdftools.crypto.providers.Certificate element : elements)
            add(element);

        return true;
    }

    /**
     * Not supported.
     */
    @Override
    public boolean addAll(int index, Collection<? extends com.pdftools.crypto.providers.Certificate> elements)
    {
        if (elements == null)
            throw new NullPointerException("'elements'");
        if (elements.isEmpty())
            return false;

        for (com.pdftools.crypto.providers.Certificate element : elements)
            add(index++, element);

        return true;
    }

    @Override
    public boolean contains(Object object)
    {
        if (object == null)
            throw new NullPointerException("'object'");
        for (com.pdftools.crypto.providers.Certificate element : this)
            if (element.equals(object))
                return true;

        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects)
    {
        for (Object element : objects)
            if (!contains(element))
                return false;

        return true;
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }

    @Override
    public Iterator<com.pdftools.crypto.providers.Certificate> iterator()
    {
        return listIterator();
    }

    @Override
    public ListIterator<com.pdftools.crypto.providers.Certificate> listIterator()
    {
        return listIterator(0);
    }

    @Override
    public ListIterator<com.pdftools.crypto.providers.Certificate> listIterator(int index)
    {
        return new IndexedIterator<com.pdftools.crypto.providers.Certificate>(this, index);
    }

    /**
     * Not supported.
     */
    @Override
    public boolean remove(Object object)
    {
        if (object == null)
            throw new NullPointerException("'object'");
        int index = indexOf(object);
        if (index < 0)
            return false;
        remove(index);
        return true;
    }

    /**
     * Not supported.
     */
    @Override
    public boolean removeAll(Collection<?> objects)
    {
        if (objects == null)
            throw new NullPointerException("'objects'");
        boolean changed = false;
        for (Object object : objects)
            changed = remove(object) || changed;
        return changed;
    }

    /**
     * Not supported.
     */
    @Override
    public boolean retainAll(Collection<?> objects)
    {
        if (objects == null)
            throw new NullPointerException("'objects'");
        boolean changed = false;
        Iterator<com.pdftools.crypto.providers.Certificate> it = this.iterator();
        while (it.hasNext())
        {
            if (!objects.contains(it.next()))
            {
                it.remove();
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public List<com.pdftools.crypto.providers.Certificate> subList(int fromIndex, int toIndex)
    {
        return new SubList<com.pdftools.crypto.providers.Certificate>(this, fromIndex, toIndex - fromIndex);
    }

    @Override
    public Object[] toArray()
    {
        Object[] array = new Object[size()];
        for (int index = 0; index < size(); index++)
            array[index] = get(index);
        return array;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T[] toArray(T[] array)
    {
        int size = size();
        if (array.length < size)
        {
            // If array is too small, allocate the new one with the same
            // component type
            array = (T[]) Array.newInstance(array.getClass().getComponentType(), size);
        }
        else if (array.length > size)
        {
            // If array is to large, set the first unassigned element to null
            array[size] = null;
        }

        int i = 0;
        for (com.pdftools.crypto.providers.Certificate e : this)
        {
            // No need for checked cast - ArrayStoreException will be thrown
            // if types are incompatible, just as required
            array[i] = (T) e;
            i++;
        }
        return array;
    }

    @Override
    public int size()
    {
        int n = sizeNative(getHandle());
        if (n == -1)
            throwLastRuntimeException(false);
        return n;
    }

    /**
     * Not supported.
     */
    @Override
    public void clear()
    {
        throw new UnsupportedOperationException("Method 'clear' is not supported by this class.");
    }

    @Override
    public int indexOf(Object obj)
    {
        if (obj == null)
            throw new NullPointerException("'obj'");
        for (int index = 0; index < size(); index++)
            if (obj.equals(get(index)))
                return index;
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj)
    {
        if (obj == null)
            throw new NullPointerException("'obj'");
        for (int index = size() - 1; index >= 0; index--)
            if (obj.equals(get(index)))
                return index;
        return -1;
    }

    /**
     * Not supported.
     */
    @Override
    public boolean add(com.pdftools.crypto.providers.Certificate element)
    {
        throw new UnsupportedOperationException("Method 'add' is not supported by this class.");
    }

    /**
     * Not supported.
     */
    @Override
    public void add(int index, com.pdftools.crypto.providers.Certificate element)
    {
        if (element == null)
            throw new NullPointerException("'element'");

        if (!insertNative(getHandle(), index, getHandle(element), element))
            throwLastRuntimeException(false);
    }

    @Override
    public com.pdftools.crypto.providers.Certificate get(int index)
    {
        long handle = getNative(getHandle(), index);
        return createObject(handle);
    }

    /**
     * Not supported.
     */
    @Override
    public com.pdftools.crypto.providers.Certificate remove(int index)
    {
        throw new UnsupportedOperationException("Method 'remove' is not supported by this class.");
    }

    /**
     * Not supported.
     */
    @Override
    public com.pdftools.crypto.providers.Certificate set(int index, com.pdftools.crypto.providers.Certificate element)
    {
        throw new UnsupportedOperationException("Method 'set' is not supported by this class.");
    }

    protected com.pdftools.crypto.providers.Certificate createObject(long handle)
    {
        if (handle == 0)
            throwLastRuntimeException(false);
        return com.pdftools.crypto.providers.Certificate.createDynamicObject(handle);
    }

    private native int sizeNative(long handle);

    private native boolean insertNative(long handle, int index, long elementHandle, com.pdftools.crypto.providers.Certificate element);
    private native long getNative(long handle, int index);

}

