/****************************************************************************
 *
 * File:            TimestampConfiguration.java
 *
 * Description:     PDFTOOLS TimestampConfiguration Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.crypto.providers.builtin;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The time-stamp configuration</h1>
 */
public class TimestampConfiguration extends com.pdftools.sign.TimestampConfiguration 
{
    protected TimestampConfiguration(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static TimestampConfiguration createDynamicObject(long handle)
    {
        return new TimestampConfiguration(handle);
    }




     /**
     * <h1>The message digest algorithm (Getter)</h1>
     * <p>
     * The algorithm used to hash the document and from which the time-stamp signature is created.</p>
     * <p>
     * <em>Note:</em> This algorithm must be supported by the time-stamp server; many support only SHA-256.</p>
     * <p>
     * Default: {@link com.pdftools.crypto.HashAlgorithm#SHA256 pdftools.crypto.HashAlgorithm.SHA256}</p>
     */
    public com.pdftools.crypto.HashAlgorithm getHashAlgorithm()
    {
        int retVal = getHashAlgorithmNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.crypto.HashAlgorithm.fromValue(retVal);
    }

     /**
     * <h1>The message digest algorithm (Setter)</h1>
     * <p>
     * The algorithm used to hash the document and from which the time-stamp signature is created.</p>
     * <p>
     * <em>Note:</em> This algorithm must be supported by the time-stamp server; many support only SHA-256.</p>
     * <p>
     * Default: {@link com.pdftools.crypto.HashAlgorithm#SHA256 pdftools.crypto.HashAlgorithm.SHA256}</p>
     *
     * @throws IllegalArgumentException If the value is invalid or not supported.
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setHashAlgorithm(com.pdftools.crypto.HashAlgorithm value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setHashAlgorithmNative(getHandle(), value.getValue());
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                case 3: throw new IllegalArgumentException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
    }




    private native int getHashAlgorithmNative(long handle);
    private native boolean setHashAlgorithmNative(long handle, int value);

}

