/****************************************************************************
 *
 * File:            Device.java
 *
 * Description:     PDFTOOLS Device Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.crypto.providers.pkcs11;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The cryptographic device (HSM, USB token, etc.)</h1>
 */
public class Device extends NativeObject 
{
    protected Device(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Device createDynamicObject(long handle)
    {
        return new Device(handle);
    }



    /**
     * <h1>Create a session</h1>
     * @param password 
     * If this parameter is not {@code null}, the session is created and {@link Session#login } executed.
     * @return 
     */
    public com.pdftools.crypto.providers.pkcs11.Session createSession(String password) 
    {
        long retHandle = createSessionNative(getHandle(), password);

        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }

        return com.pdftools.crypto.providers.pkcs11.Session.createDynamicObject(retHandle);
    }



     /**
     * <h1>Description of the device (Getter)</h1>
     * 
     */
    public String getDescription()
    {
        String retVal = getDescriptionNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * <h1>ID of the device's manufacturer (Getter)</h1>
     * 
     */
    public String getManufacturerID()
    {
        String retVal = getManufacturerIDNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }




    private native long createSessionNative(long handle, String password);

    private native String getDescriptionNative(long handle);
    private native String getManufacturerIDNative(long handle);

}

