/****************************************************************************
 *
 * File:            CopyStrategy.java
 *
 * Description:     CopyStrategy Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.documentassembly;

/**
 * 
 */
public enum CopyStrategy  
{
    /**
     * 
     * The elements are copied as-is to the output document.
     */
    COPY(1),
    /**
     * 
     * The visual appearance of elements is preserved, but they are not interactive anymore.
     */
    FLATTEN(2),
    /**
     * 
     * The elements are removed completely.
     */
    REMOVE(3);

    CopyStrategy(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static CopyStrategy fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return COPY;
            case 2: return FLATTEN;
            case 3: return REMOVE;
        }
        throw new IllegalArgumentException("Unknown value for CopyStrategy: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
