/****************************************************************************
 *
 * File:            NameConflictResolution.java
 *
 * Description:     NameConflictResolution Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.documentassembly;

/**
 * 
 */
public enum NameConflictResolution  
{
    /**
     * 
     * Elements with the same name are considered the same and are merged if possible.
     */
    MERGE(1),
    /**
     * 
     * Elements with the same name are considered different and the later occurrence is renamed.
     */
    RENAME(2);

    NameConflictResolution(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static NameConflictResolution fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return MERGE;
            case 2: return RENAME;
        }
        throw new IllegalArgumentException("Unknown value for NameConflictResolution: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
