/****************************************************************************
 *
 * File:            NamedDestinationCopyStrategy.java
 *
 * Description:     NamedDestinationCopyStrategy Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.documentassembly;

/**
 * 
 */
public enum NamedDestinationCopyStrategy  
{
    /**
     * <h1>Copy named destinations</h1>
     * Named destinations are copyied as-is.
     */
    COPY(1),
    /**
     * <h1>Resolve named destinations</h1>
     * Named destinations are resolved and converted to direct destinations.
     */
    RESOLVE(2);

    NamedDestinationCopyStrategy(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static NamedDestinationCopyStrategy fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return COPY;
            case 2: return RESOLVE;
        }
        throw new IllegalArgumentException("Unknown value for NamedDestinationCopyStrategy: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
