/****************************************************************************
 *
 * File:            PageRotation.java
 *
 * Description:     PageRotation Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.documentassembly;

/**
 * 
 */
public enum PageRotation  
{
    /**
     * 
     * No rotation is applied.
     */
    NO_ROTATION(0),
    /**
     * 
     * Rotation for 90 degrees clockwise.
     */
    CLOCKWISE90(1),
    /**
     * 
     * Rotation for 180 degrees clockwise.
     */
    CLOCKWISE180(2),
    /**
     * 
     * Rotation for 270 degrees clockwise.
     */
    CLOCKWISE270(3);

    PageRotation(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static PageRotation fromValue(int value) 
    {
        switch (value) 
        {
            case 0: return NO_ROTATION;
            case 1: return CLOCKWISE90;
            case 2: return CLOCKWISE180;
            case 3: return CLOCKWISE270;
        }
        throw new IllegalArgumentException("Unknown value for PageRotation: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
