/****************************************************************************
 *
 * File:            Size.java
 *
 * Description:     Size Struct
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.geometry.integer;

import java.util.Objects;

public class Size
{
    /**
     * Constructor.
     */
    public Size()
    {
    }

    public Size(int width, int height)
    {
        this.width = width;
        this.height = height;
    }

    /**
     * Gets {@link Size#width }
     */
    public int getWidth()
    {
        return this.width;
    }

    /**
     * Sets {@link Size#width }
     */
    public void setWidth(int width)
    {
        this.width = width;
    }

    /**
     * Gets {@link Size#height }
     */
    public int getHeight()
    {
        return this.height;
    }

    /**
     * Sets {@link Size#height }
     */
    public void setHeight(int height)
    {
        this.height = height;
    }


    /**
     * <h1>Width (horizontal size)</h1>
     */
    public int width;
    /**
     * <h1>Height (vertical size)</h1>
     */
    public int height;

    @Override
    public boolean equals(Object obj)
    {
        if (obj != null && obj instanceof Size)
        {
            if (((Size) obj).width != width)
                return false;
            if (((Size) obj).height != height)
                return false;

            return true;
        }

        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(width, height);
    }
}

