/****************************************************************************
 *
 * File:            MultiPageDocument.java
 *
 * Description:     PDFTOOLS MultiPageDocument Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.image;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The image document of an image format that supports multi-page images</h1>
 * This class is used for TIFF images, which can contain one or more pages.
 */
public class MultiPageDocument extends com.pdftools.image.Document 
{
    protected MultiPageDocument(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static MultiPageDocument createDynamicObject(long handle)
    {
        return new MultiPageDocument(handle);
    }




     /**
     * <h1>The pages of the image (Getter)</h1>
     * 
     */
    public com.pdftools.image.PageList getPages()
    {
        long retHandle = getPagesNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.image.PageList.createDynamicObject(retHandle);

    }




    private native long getPagesNative(long handle);

}

