/****************************************************************************
 *
 * File:            Page.java
 *
 * Description:     PDFTOOLS Page Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.image;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The page of an image document</h1>
 */
public class Page extends NativeObject 
{
    protected Page(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Page createDynamicObject(long handle)
    {
        return new Page(handle);
    }




     /**
     * <h1>The size of the page in number of pixels (Getter)</h1>
     * 
     *
     * @throws com.pdftools.GenericException A generic error occurred.
     */
    public com.pdftools.geometry.integer.Size getSize()
        throws 
            com.pdftools.GenericException
    {
        com.pdftools.geometry.integer.Size retVal = getSizeNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                case 10: throw new com.pdftools.GenericException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * <h1>The resolution of the page (Getter)</h1>
     * The resolution can be {@code null} if the image does not specify a resolution.
     *
     * @throws com.pdftools.GenericException A generic error occurred.
     */
    public com.pdftools.geometry.units.Resolution getResolution()
        throws 
            com.pdftools.GenericException
    {
        com.pdftools.geometry.units.Resolution retVal = getResolutionNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                case 10: throw new com.pdftools.GenericException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }




    private native com.pdftools.geometry.integer.Size getSizeNative(long handle);
    private native com.pdftools.geometry.units.Resolution getResolutionNative(long handle);

}

