/****************************************************************************
 *
 * File:            SinglePageDocument.java
 *
 * Description:     PDFTOOLS SinglePageDocument Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.image;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The image document of an image format that only supports single-page images</h1>
 * This class is used for the following image formats:
 * <ul>
 * <li>
 * JPEG</li>
 * <li>
 * BMP</li>
 * <li>
 * GIF</li>
 * <li>
 * HEIC/HEIF</li>
 * <li>
 * PNG</li>
 * <li>
 * JBIG2</li>
 * <li>
 * JPEG2000</li>
 * </ul>
 */
public class SinglePageDocument extends com.pdftools.image.Document 
{
    protected SinglePageDocument(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static SinglePageDocument createDynamicObject(long handle)
    {
        return new SinglePageDocument(handle);
    }




     /**
     * <h1>The page of the image (Getter)</h1>
     * 
     */
    public com.pdftools.image.Page getPage()
    {
        long retHandle = getPageNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.image.Page.createDynamicObject(retHandle);

    }




    private native long getPageNative(long handle);

}

