/****************************************************************************
 *
 * File:            ImageMapping.java
 *
 * Description:     PDFTOOLS ImageMapping Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.image2pdf;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The base class for image mappings</h1>
 * The image mapping specifies how an input image is transformed and placed
 * onto the output PDF page.
 */
public abstract class ImageMapping extends NativeObject 
{
    protected ImageMapping(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ImageMapping createDynamicObject(long handle)
    {
        int type = getType(handle);
        switch (type)
        {
            case 1:
                return com.pdftools.image2pdf.Auto.createDynamicObject(handle);
            case 2:
                return com.pdftools.image2pdf.ShrinkToPage.createDynamicObject(handle);
            case 3:
                return com.pdftools.image2pdf.ShrinkToFit.createDynamicObject(handle);
            case 4:
                return com.pdftools.image2pdf.ShrinkToPortrait.createDynamicObject(handle);
            default:
                return null;
        }
    }





    private static native int getType(long handle);
}

