/****************************************************************************
 *
 * File:            ImageOptions.java
 *
 * Description:     PDFTOOLS ImageOptions Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.image2pdf;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The conversion options related to the images</h1>
 */
public class ImageOptions extends NativeObject 
{
    protected ImageOptions(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ImageOptions createDynamicObject(long handle)
    {
        return new ImageOptions(handle);
    }




     /**
     * <h1>The image mapping (Getter)</h1>
     * <p>
     * The image mapping specifies how an input image is transformed and placed
     * onto the output PDF page.</p>
     * <p>
     * Default: {@link ShrinkToFit }</p>
     */
    public com.pdftools.image2pdf.ImageMapping getMapping()
    {
        long retHandle = getMappingNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.image2pdf.ImageMapping.createDynamicObject(retHandle);

    }

     /**
     * <h1>The image mapping (Setter)</h1>
     * <p>
     * The image mapping specifies how an input image is transformed and placed
     * onto the output PDF page.</p>
     * <p>
     * Default: {@link ShrinkToFit }</p>
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setMapping(com.pdftools.image2pdf.ImageMapping value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setMappingNative(getHandle(), getHandle(value), value);
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }




    private native long getMappingNative(long handle);
    private native boolean setMappingNative(long handle, long value, com.pdftools.image2pdf.ImageMapping valueObj);

}

