/****************************************************************************
 *
 * File:            ShrinkToPortrait.java
 *
 * Description:     PDFTOOLS ShrinkToPortrait Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.image2pdf;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The image mapping that places the image onto portrait pages of the specified size</h1>
 * Place images onto portrait pages. Large images are scaled down
 * to fit onto {@link ShrinkToPortrait#getPageSize }.
 *
 * @deprecated Deprecated in Version 1.1. Use 'ShrinkToFit' instead.
 */
public class ShrinkToPortrait extends com.pdftools.image2pdf.ImageMapping 
{
    protected ShrinkToPortrait(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ShrinkToPortrait createDynamicObject(long handle)
    {
        return new ShrinkToPortrait(handle);
    }


    /**
     * 
     */
    public ShrinkToPortrait()
    {
        this(newHelper());
    }

    private static long newHelper()
    {
        long handle = newNative();
        if (handle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }

        return handle;
    }



     /**
     * <h1>The page size (Getter)</h1>
     * <p>
     * All output pages are created as that size and in portrait mode.</p>
     * <p>
     * Default value: "A4" (210mm 297mm)
     * </p>
     */
    public com.pdftools.geometry.units.Size getPageSize()
    {
        com.pdftools.geometry.units.Size retVal = getPageSizeNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }

     /**
     * <h1>The page size (Setter)</h1>
     * <p>
     * All output pages are created as that size and in portrait mode.</p>
     * <p>
     * Default value: "A4" (210mm 297mm)
     * </p>
     *
     * @throws IllegalArgumentException The argument is smaller than "3pt 3pt" or larger than "14400pt 14400pt".
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setPageSize(com.pdftools.geometry.units.Size value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setPageSizeNative(getHandle(), value.getWidthValue(), value.getHeightValue());
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                case 3: throw new IllegalArgumentException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
    }


     /**
     * <h1>The page margin (Getter)</h1>
     * Default value: 20mm (0.79in)
     */
    public com.pdftools.geometry.units.Margin getPageMargin()
    {
        com.pdftools.geometry.units.Margin retVal = getPageMarginNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }

     /**
     * <h1>The page margin (Setter)</h1>
     * Default value: 20mm (0.79in)
     *
     * @throws IllegalArgumentException The argument has negative margin values.
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setPageMargin(com.pdftools.geometry.units.Margin value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setPageMarginNative(getHandle(), value.getLeftValue(), value.getBottomValue(), value.getRightValue(), value.getTopValue());
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                case 3: throw new IllegalArgumentException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
    }




    private static native long newNative();
    private native com.pdftools.geometry.units.Size getPageSizeNative(long handle);
    private native boolean setPageSizeNative(long handle, double valueWidth, double valueHeight);
    private native com.pdftools.geometry.units.Margin getPageMarginNative(long handle);
    private native boolean setPageMarginNative(long handle, double valueLeft, double valueBottom, double valueRight, double valueTop);

}

