/****************************************************************************
 *
 * File:            Profile.java
 *
 * Description:     PDFTOOLS Profile Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.image2pdf.profiles;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The base class for image to PDF conversion profiles</h1>
 * A profile implements the conversion settings suitable for a practical
 * use case.
 */
public abstract class Profile extends NativeObject 
{
    protected Profile(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Profile createDynamicObject(long handle)
    {
        int type = getType(handle);
        switch (type)
        {
            case 1:
                return com.pdftools.image2pdf.profiles.Default.createDynamicObject(handle);
            case 2:
                return com.pdftools.image2pdf.profiles.Archive.createDynamicObject(handle);
            default:
                return null;
        }
    }




     /**
     * <h1>The image conversion options (Getter)</h1>
     * 
     */
    public com.pdftools.image2pdf.ImageOptions getImageOptions()
    {
        long retHandle = getImageOptionsNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.image2pdf.ImageOptions.createDynamicObject(retHandle);

    }




    private static native int getType(long handle);
    private native long getImageOptionsNative(long handle);

}

