/****************************************************************************
 *
 * File:            NativeObject.java
 *
 * Description:     Internal Native Object abstract Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.internal;

import com.pdftools.*;

public abstract class NativeObject extends NativeBase
{
    private long handle;

    @Override
    public boolean equals(Object other)
    {
        if (((NativeObject)other).handle == 0)
            return false;
        if (!(other instanceof NativeObject))
            return false;
        return equalsNative(handle, ((NativeObject)other).handle);
    }

    @Override
    public int hashCode()
    {
        return hashCodeNative(handle);
    }

    protected NativeObject(long handle)
    {
        this.handle = handle;
    }

    protected long getHandle()
    {
        if (handle == 0)
            throw new IllegalStateException();

        return handle;
    }

    protected void setHandle(long handle)
    {
        this.handle = handle;
    }

    protected void addRef()
    {
        addRef(getHandle());
    }

    protected void finalize() throws Throwable
    {
        try
        {
            finalize(handle);
        }
        finally
        {
            super.finalize();
        }
    }

    private static native void finalize(long hObject);
    private static native void addRef(long hObject);
    private static native boolean equalsNative(long hObject, long hOther);
    private static native int hashCodeNative(long hObject);
}
