/****************************************************************************
 *
 * File:            CompressionAlgorithmSelection.java
 *
 * Description:     CompressionAlgorithmSelection Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.optimization;

/**
 * <h1>The strategy for recompressing images</h1>
 * The strategy expresses the broad goal when recompressing images.
 */
public enum CompressionAlgorithmSelection  
{
    /**
     * 
     * The image quality is preserved as far as possible.
     */
    PRESERVE_QUALITY(1),
    /**
     * 
     * A compromise between
     * {@link CompressionAlgorithmSelection#PRESERVE_QUALITY }
     * and
     * {@link CompressionAlgorithmSelection#SPEED }.
     */
    BALANCED(2),
    /**
     * 
     * Favor fast compression time over image quality.
     */
    SPEED(3);

    CompressionAlgorithmSelection(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static CompressionAlgorithmSelection fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return PRESERVE_QUALITY;
            case 2: return BALANCED;
            case 3: return SPEED;
        }
        throw new IllegalArgumentException("Unknown value for CompressionAlgorithmSelection: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
