/****************************************************************************
 *
 * File:            ConversionStrategy.java
 *
 * Description:     ConversionStrategy Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.optimization;

/**
 * <h1>The conversion strategy for PDF objects</h1>
 */
public enum ConversionStrategy  
{
    /**
     * 
     * The object is copied onto the output page.
     */
    COPY(1),
    /**
     * 
     * The object is removed, but its visual appearance is drawn as
     * non-editable graphic onto the output page.
     */
    FLATTEN(2);

    ConversionStrategy(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static ConversionStrategy fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return COPY;
            case 2: return FLATTEN;
        }
        throw new IllegalArgumentException("Unknown value for ConversionStrategy: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
