/****************************************************************************
 *
 * File:            RemovalStrategy.java
 *
 * Description:     RemovalStrategy Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.optimization;

/**
 * <h1>The removal strategy for PDF objects</h1>
 */
public enum RemovalStrategy  
{
    /**
     * 
     * The object is removed, but its visual appearance is drawn as
     * non-editable graphic onto the output page.
     */
    FLATTEN(2),
    /**
     * 
     * The object is removed together with its visual appearance.
     */
    REMOVE(3);

    RemovalStrategy(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static RemovalStrategy fromValue(int value) 
    {
        switch (value) 
        {
            case 2: return FLATTEN;
            case 3: return REMOVE;
        }
        throw new IllegalArgumentException("Unknown value for RemovalStrategy: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
