/****************************************************************************
 *
 * File:            Archive.java
 *
 * Description:     PDFTOOLS Archive Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.optimization.profiles;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The optimization profile suitable for archiving</h1>
 * <p>
 * This profile provides minimal document modification and is well suited for
 * reducing the file size prior to converting to PDF/A.
 * The optimizer itself does not create PDF/A output but
 * merely tries to preserve PDF/A conformance.</p>
 * <p>
 * Alternate images and thumbnails are removed.
 * The resolution and color space of images stay untouched.</p>
 * <p>
 * When an image is recompressed, the
 * {@link com.pdftools.optimization.CompressionAlgorithmSelection#PRESERVE_QUALITY pdftools.optimization.CompressionAlgorithmSelection.PRESERVE_QUALITY}
 * strategy is used; this can be overridden through the
 * property {@link Profile#getImageRecompressionOptions }.</p>
 * <p>
 * For PDF/A conforming input files, the PDF/A conformance is preserved if possible.
 * For other files, the PDF version is updated to PDF 1.7 or higher.
 * </p>
 */
public class Archive extends com.pdftools.optimization.profiles.Profile 
{
    protected Archive(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Archive createDynamicObject(long handle)
    {
        return new Archive(handle);
    }


    /**
     * 
     */
    public Archive()
    {
        this(newHelper());
    }

    private static long newHelper()
    {
        long handle = newNative();
        if (handle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }

        return handle;
    }




    private static native long newNative();
}

