/****************************************************************************
 *
 * File:            Print.java
 *
 * Description:     PDFTOOLS Print Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.optimization.profiles;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The optimization profile suitable for printing</h1>
 * <p>
 * All colors are converted to CMYK for optimal output on printing devices.
 * Spider (web capture) information is removed.
 * Embedded Type1 (PostScript) fonts are converted to Type1C
 * (Compact Font Format) which further reduces the file size.
 * The resolution of images stays untouched.</p>
 * <p>
 * When an image is recompressed, the
 * {@link com.pdftools.optimization.CompressionAlgorithmSelection#PRESERVE_QUALITY pdftools.optimization.CompressionAlgorithmSelection.PRESERVE_QUALITY}
 * strategy is used; this can be overridden through the
 * property {@link Profile#getImageRecompressionOptions }.</p>
 * <p>
 * With this profile, the output PDF version is updated to PDF 1.7 or higher and
 * PDF/A conformance removed.
 * </p>
 */
public class Print extends com.pdftools.optimization.profiles.Profile 
{
    protected Print(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Print createDynamicObject(long handle)
    {
        return new Print(handle);
    }


    /**
     * 
     */
    public Print()
    {
        this(newHelper());
    }

    private static long newHelper()
    {
        long handle = newNative();
        if (handle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }

        return handle;
    }




    private static native long newNative();
}

