/****************************************************************************
 *
 * File:            CertificationSignature.java
 *
 * Description:     PDFTOOLS CertificationSignature Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>A document certification (MDP) signature that certifies the document</h1>
 * These signatures are also called Document Modification Detection and Prevention (MDP) signatures.
 * This type of signature enables the detection of rejected changes specified by the author.
 */
public class CertificationSignature extends com.pdftools.pdf.Signature 
{
    protected CertificationSignature(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static CertificationSignature createDynamicObject(long handle)
    {
        return new CertificationSignature(handle);
    }




     /**
     * <h1>The access permissions granted for this document (Getter)</h1>
     * Note that for encrypted PDF documents, the restrictions defined by this {@code CertificationSignature} are in addition
     * to the document's {@link Document#getPermissions }.
     *
     * @throws IllegalStateException If the object has already been closed
     */
    public com.pdftools.pdf.MdpPermissions getPermissions()
    {
        int retVal = getPermissionsNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                case 2: throw new IllegalStateException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.pdf.MdpPermissions.fromValue(retVal);
    }




    private native int getPermissionsNative(long handle);

}

