/****************************************************************************
 *
 * File:            DocumentSignature.java
 *
 * Description:     PDFTOOLS DocumentSignature Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>A document signature that signs the document</h1>
 * Document signatures are sometimes also called approval signatures.
 * This type of signature lets you verify the integrity of the signed part of the document and authenticate the signer’s identity.
 */
public class DocumentSignature extends com.pdftools.pdf.Signature 
{
    protected DocumentSignature(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static DocumentSignature createDynamicObject(long handle)
    {
        return new DocumentSignature(handle);
    }





}

