/****************************************************************************
 *
 * File:            DocumentTimestamp.java
 *
 * Description:     PDFTOOLS DocumentTimestamp Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>A document time-stamp signature that time-stamps the document</h1>
 * This type of signature provides evidence that the document existed at a specific time and protects the document’s integrity.
 */
public class DocumentTimestamp extends com.pdftools.pdf.SignedSignatureField 
{
    protected DocumentTimestamp(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static DocumentTimestamp createDynamicObject(long handle)
    {
        return new DocumentTimestamp(handle);
    }





}

