/****************************************************************************
 *
 * File:            MdpPermissions.java
 *
 * Description:     MdpPermissions Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf;

/**
 * 
 */
public enum MdpPermissions  
{
    /**
     * 
     * No changes to the document shall be permitted;
     * any change to the document invalidates the signature.
     */
    NO_CHANGES(1),
    /**
     * 
     * Permitted changes are filling in forms, instantiating page templates, and signing;
     * other changes invalidate the signature.
     */
    FORM_FILLING(2),
    /**
     * 
     * Permitted changes are the same as for {@link MdpPermissions#FORM_FILLING },
     * as well as annotation creation, deletion, and modification;
     * other changes invalidate the signature.
     */
    ANNOTATE(3);

    MdpPermissions(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static MdpPermissions fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return NO_CHANGES;
            case 2: return FORM_FILLING;
            case 3: return ANNOTATE;
        }
        throw new IllegalArgumentException("Unknown value for MdpPermissions: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
