/****************************************************************************
 *
 * File:            Permission.java
 *
 * Description:     Permission Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf;

import com.pdftools.internal.Flag;
import java.util.EnumSet;

/**
 * <h1>The permissions allowed by a PDF document</h1>
 * <ul>
 * <li>
 * See {@link Document#getPermissions } to read the permissions of a PDF document.</li>
 * <li>
 * See {@link OutputOptions#getEncryption } to set the permissions when encrypting a PDF document.</li>
 * </ul>
 */
public enum Permission implements Flag 
{
    /**
     * <h1>Allow low resolution printing.</h1>
     */
    PRINT(4),
    /**
     * <h1>Allow changing the document.</h1>
     */
    MODIFY(8),
    /**
     * <h1>Allow content copying or extraction.</h1>
     */
    COPY(16),
    /**
     * <h1>Allow annotations.</h1>
     */
    ANNOTATE(32),
    /**
     * <h1>Allow filling of form fields.</h1>
     */
    FILL_FORMS(256),
    /**
     * <h1>Allow support for disabilities.</h1>
     */
    SUPPORT_DISABILITIES(512),
    /**
     * <h1>Allow document assembly.</h1>
     */
    ASSEMBLE(1024),
    /**
     * <h1>Allow high resolution printing.</h1>
     */
    DIGITAL_PRINT(2048);
    /**
     * <h1>No permission.</h1>
     */
    public static final EnumSet<Permission> NONE = EnumSet.noneOf(Permission.class);
    /**
     * <h1>All Permission.</h1>
     */
    public static final EnumSet<Permission> ALL = EnumSet.allOf(Permission.class);

    Permission(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public int getFlag() 
    {
        return value;
    }

    private int value;
}
