/****************************************************************************
 *
 * File:            Signature.java
 *
 * Description:     PDFTOOLS Signature Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>A base class for certain signature types</h1>
 */
public abstract class Signature extends com.pdftools.pdf.SignedSignatureField 
{
    protected Signature(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Signature createDynamicObject(long handle)
    {
        int type = getType(handle);
        switch (type)
        {
            case 1:
                return com.pdftools.pdf.DocumentSignature.createDynamicObject(handle);
            case 2:
                return com.pdftools.pdf.CertificationSignature.createDynamicObject(handle);
            default:
                return null;
        }
    }




     /**
     * <h1>The location of signing (Getter)</h1>
     * The CPU host name or physical location of the signing.
     *
     * @throws IllegalStateException If the object has already been closed
     */
    public String getLocation()
    {
        String retVal = getLocationNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                case 2: throw new IllegalStateException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * <h1>The reason for signing (Getter)</h1>
     * 
     *
     * @throws IllegalStateException If the object has already been closed
     */
    public String getReason()
    {
        String retVal = getReasonNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                case 2: throw new IllegalStateException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * <h1>The contact information of the signer (Getter)</h1>
     * Information provided by the signer to enable a recipient to contact
     * the signer to verify the signature.
     * For example, a phone number.
     *
     * @throws IllegalStateException If the object has already been closed
     */
    public String getContactInfo()
    {
        String retVal = getContactInfoNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                case 2: throw new IllegalStateException(getLastErrorMessage());

                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }




    private static native int getType(long handle);
    private native String getLocationNative(long handle);
    private native String getReasonNative(long handle);
    private native String getContactInfoNative(long handle);

}

