/****************************************************************************
 *
 * File:            UnsignedSignatureField.java
 *
 * Description:     PDFTOOLS UnsignedSignatureField Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>An unsigned signature field</h1>
 * An unsigned signature field that can be signed.
 * The purpose of the signature field is to indicate that the document should be signed and to 
 * define the page and position where the visual appearance of the signature should be placed.
 * This is especially useful for forms and contracts that have dedicated spaces for signatures.
 */
public class UnsignedSignatureField extends com.pdftools.pdf.SignatureField 
{
    protected UnsignedSignatureField(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static UnsignedSignatureField createDynamicObject(long handle)
    {
        return new UnsignedSignatureField(handle);
    }





}

