/****************************************************************************
 *
 * File:            XfaType.java
 *
 * Description:     XfaType Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf;

/**
 * <h1>The XFA type of a PDF document</h1>
 * See {@link Document#getXfa } to get the XFA type of a PDF document.
 */
public enum XfaType  
{
    /**
     * <h1>No XFA document</h1>
     * The document is not an XFA document but a regular PDF document.
     */
    NO_XFA(0),
    /**
     * <h1>XFA document</h1>
     * The document is an XFA document.
     * The document cannot be processed by many components, so it is recommended to convert it to a PDF document beforehand.
     */
    XFA_NEEDS_RENDERING(1),
    /**
     * <h1>Rendered XFA document</h1>
     * The document is a "rendered" XFA document where the PDF pages' content has been generated from the XFA form.
     * Such documents can be processed as regular PDF documents.
     * However, there is no guarantee that the generated pages accurately reflect the XFA document.
     */
    XFA_RENDERED(2);

    XfaType(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static XfaType fromValue(int value) 
    {
        switch (value) 
        {
            case 0: return NO_XFA;
            case 1: return XFA_NEEDS_RENDERING;
            case 2: return XFA_RENDERED;
        }
        throw new IllegalArgumentException("Unknown value for XfaType: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
