/****************************************************************************
 *
 * File:            AnnotationOptions.java
 *
 * Description:     AnnotationOptions Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

/**
 * <h1>Defines how to render annotations and their popups</h1>
 * <p>
 * Annotations associate an object such as a sticky note, link or rich media
 * with a location on a PDF page; they may also provide user interaction
 * by means of the mouse and keyboard.</p>
 * <p>
 * Some annotations have an associated popup.
 * </p>
 */
public enum AnnotationOptions  
{
    /**
     * <h1>Render the annotation without the associated popup</h1>
     */
    SHOW_ANNOTATIONS(1),
    /**
     * <h1>Render the annotation and the associated popup</h1>
     */
    SHOW_ANNOTATIONS_AND_POPUPS(2);

    AnnotationOptions(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static AnnotationOptions fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return SHOW_ANNOTATIONS;
            case 2: return SHOW_ANNOTATIONS_AND_POPUPS;
        }
        throw new IllegalArgumentException("Unknown value for AnnotationOptions: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
