/****************************************************************************
 *
 * File:            BackgroundType.java
 *
 * Description:     BackgroundType Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

/**
 * <h1>The background type to use when rendering into an image</h1>
 */
public enum BackgroundType  
{
    /**
     * <h1>White background</h1>
     * The input PDF content will be rendered on a white background.
     */
    WHITE(1),
    /**
     * <h1>Transparent background</h1>
     * The input PDF content will be rendered into an image with an
     * alpha channel and no background.
     */
    TRANSPARENT(2);

    BackgroundType(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static BackgroundType fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return WHITE;
            case 2: return TRANSPARENT;
        }
        throw new IllegalArgumentException("Unknown value for BackgroundType: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
