/****************************************************************************
 *
 * File:            ContentOptions.java
 *
 * Description:     PDFTOOLS ContentOptions Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The parameters how to render PDF content elements</h1>
 */
public class ContentOptions extends NativeObject 
{
    protected ContentOptions(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ContentOptions createDynamicObject(long handle)
    {
        return new ContentOptions(handle);
    }




     /**
     * <h1>The render strategy for annotations (Getter)</h1>
     * <p>
     * Defines whether to render annotation popups.
     * For details, see {@link AnnotationOptions }.</p>
     * <p>
     * Default: {@link AnnotationOptions#SHOW_ANNOTATIONS }</p>
     */
    public com.pdftools.pdf2image.AnnotationOptions getAnnotations()
    {
        int retVal = getAnnotationsNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.pdf2image.AnnotationOptions.fromValue(retVal);
    }

     /**
     * <h1>The render strategy for annotations (Setter)</h1>
     * <p>
     * Defines whether to render annotation popups.
     * For details, see {@link AnnotationOptions }.</p>
     * <p>
     * Default: {@link AnnotationOptions#SHOW_ANNOTATIONS }</p>
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setAnnotations(com.pdftools.pdf2image.AnnotationOptions value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setAnnotationsNative(getHandle(), value.getValue());
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }


     /**
     * <p>
     * Defines whether to render text. When set to {@code false}, text rendering is skipped entirely.
     * Text embedded in images and text created by drawing lines or paths are still rendered.
     * Skipping text rendering can speed up the rendering process, especially for documents with many text elements.</p>
     * <p>
     * Default: {@code true}.
     * </p>
     */
    public boolean getRenderText()
    {
        boolean retVal = getRenderTextNative(getHandle());
        if (!retVal)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }

     /**
     * <p>
     * Defines whether to render text. When set to {@code false}, text rendering is skipped entirely.
     * Text embedded in images and text created by drawing lines or paths are still rendered.
     * Skipping text rendering can speed up the rendering process, especially for documents with many text elements.</p>
     * <p>
     * Default: {@code true}.
     * </p>
     */
    public void setRenderText(boolean value)
    {
        boolean retVal = setRenderTextNative(getHandle(), value);
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }




    private native int getAnnotationsNative(long handle);
    private native boolean setAnnotationsNative(long handle, int value);
    private native boolean getRenderTextNative(long handle);
    private native boolean setRenderTextNative(long handle, boolean value);

}

