/****************************************************************************
 *
 * File:            FaxImageOptions.java
 *
 * Description:     PDFTOOLS FaxImageOptions Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The settings for TIFF Fax output images</h1>
 * Create a black-and-white (bitonal) TIFF Fax output image.
 * For the output file name, it is recommended to use the file extension ".tif".
 */
public class FaxImageOptions extends com.pdftools.pdf2image.ImageOptions 
{
    protected FaxImageOptions(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static FaxImageOptions createDynamicObject(long handle)
    {
        return new FaxImageOptions(handle);
    }




     /**
     * <h1>The vertical image resolution (Getter)</h1>
     * <p>
     * This property allows a choice of which vertical
     * resolution to use.
     * For details, see {@link FaxVerticalResolution }.</p>
     * <p>
     * Note that the horizontal resolution is fixed at 204 DPI by the
     * Fax standard.</p>
     * <p>
     * Default: {@link FaxVerticalResolution#STANDARD }</p>
     */
    public com.pdftools.pdf2image.FaxVerticalResolution getVerticalResolution()
    {
        int retVal = getVerticalResolutionNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.pdf2image.FaxVerticalResolution.fromValue(retVal);
    }

     /**
     * <h1>The vertical image resolution (Setter)</h1>
     * <p>
     * This property allows a choice of which vertical
     * resolution to use.
     * For details, see {@link FaxVerticalResolution }.</p>
     * <p>
     * Note that the horizontal resolution is fixed at 204 DPI by the
     * Fax standard.</p>
     * <p>
     * Default: {@link FaxVerticalResolution#STANDARD }</p>
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setVerticalResolution(com.pdftools.pdf2image.FaxVerticalResolution value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setVerticalResolutionNative(getHandle(), value.getValue());
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }


     /**
     * <h1>The Fax compression algorithm (Getter)</h1>
     * <p>
     * This property allows a choice of which compression
     * type to use.
     * For details, see {@link TiffBitonalCompressionType }.</p>
     * <p>
     * Default: {@link TiffBitonalCompressionType#G3 }</p>
     */
    public com.pdftools.pdf2image.TiffBitonalCompressionType getCompression()
    {
        int retVal = getCompressionNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.pdf2image.TiffBitonalCompressionType.fromValue(retVal);
    }

     /**
     * <h1>The Fax compression algorithm (Setter)</h1>
     * <p>
     * This property allows a choice of which compression
     * type to use.
     * For details, see {@link TiffBitonalCompressionType }.</p>
     * <p>
     * Default: {@link TiffBitonalCompressionType#G3 }</p>
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setCompression(com.pdftools.pdf2image.TiffBitonalCompressionType value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setCompressionNative(getHandle(), value.getValue());
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }




    private native int getVerticalResolutionNative(long handle);
    private native boolean setVerticalResolutionNative(long handle, int value);
    private native int getCompressionNative(long handle);
    private native boolean setCompressionNative(long handle, int value);

}

