/****************************************************************************
 *
 * File:            FaxVerticalResolution.java
 *
 * Description:     FaxVerticalResolution Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

/**
 * <h1>The vertical resolution of Fax images</h1>
 * The two resolutions available in Fax images.
 */
public enum FaxVerticalResolution  
{
    /**
     * <h1>A vertical resolution of 98 DPI (dots per inch)</h1>
     */
    STANDARD(1),
    /**
     * <h1>A vertical resolution of 196 DPI (dots per inch)</h1>
     */
    HIGH(2);

    FaxVerticalResolution(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static FaxVerticalResolution fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return STANDARD;
            case 2: return HIGH;
        }
        throw new IllegalArgumentException("Unknown value for FaxVerticalResolution: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
