/****************************************************************************
 *
 * File:            ImageOptions.java
 *
 * Description:     PDFTOOLS ImageOptions Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The base class for output image options</h1>
 */
public abstract class ImageOptions extends NativeObject 
{
    protected ImageOptions(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ImageOptions createDynamicObject(long handle)
    {
        int type = getType(handle);
        switch (type)
        {
            case 1:
                return com.pdftools.pdf2image.FaxImageOptions.createDynamicObject(handle);
            case 2:
                return com.pdftools.pdf2image.TiffJpegImageOptions.createDynamicObject(handle);
            case 3:
                return com.pdftools.pdf2image.TiffLzwImageOptions.createDynamicObject(handle);
            case 4:
                return com.pdftools.pdf2image.TiffFlateImageOptions.createDynamicObject(handle);
            case 5:
                return com.pdftools.pdf2image.PngImageOptions.createDynamicObject(handle);
            case 6:
                return com.pdftools.pdf2image.JpegImageOptions.createDynamicObject(handle);
            default:
                return null;
        }
    }





    private static native int getType(long handle);
}

