/****************************************************************************
 *
 * File:            ImageSectionMapping.java
 *
 * Description:     PDFTOOLS ImageSectionMapping Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The base class for image section mappings</h1>
 * An image section mapping specifies how a PDF page, or a section of
 * it, is transformed (e.g. cropped or scaled) and placed
 * onto the target image.
 */
public abstract class ImageSectionMapping extends NativeObject 
{
    protected ImageSectionMapping(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ImageSectionMapping createDynamicObject(long handle)
    {
        int type = getType(handle);
        switch (type)
        {
            case 1:
                return com.pdftools.pdf2image.RenderPageAsFax.createDynamicObject(handle);
            case 2:
                return com.pdftools.pdf2image.RenderPageAtResolution.createDynamicObject(handle);
            case 3:
                return com.pdftools.pdf2image.RenderPageToMaxImageSize.createDynamicObject(handle);
            default:
                return null;
        }
    }





    private static native int getType(long handle);
}

