/****************************************************************************
 *
 * File:            PngColorSpace.java
 *
 * Description:     PngColorSpace Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

/**
 * <h1>The color space used in PNG images</h1>
 */
public enum PngColorSpace  
{
    /**
     * 
     */
    RGB(1),
    /**
     * 
     */
    GRAY(2);

    PngColorSpace(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static PngColorSpace fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return RGB;
            case 2: return GRAY;
        }
        throw new IllegalArgumentException("Unknown value for PngColorSpace: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
