/****************************************************************************
 *
 * File:            RenderPageAsFax.java
 *
 * Description:     PDFTOOLS RenderPageAsFax Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The image section mapping suitable for Fax output images</h1>
 * <p>
 * Render a PDF page without scaling onto the image, top-aligned
 * and horizontally centered.</p>
 * <p>
 * Note that, the image has a fixed width of 1728 pixels / 8.5 inches.</p>
 * <p>
 * A page larger than the target image is scaled down to fit in.
 * </p>
 */
public class RenderPageAsFax extends com.pdftools.pdf2image.ImageSectionMapping 
{
    protected RenderPageAsFax(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static RenderPageAsFax createDynamicObject(long handle)
    {
        return new RenderPageAsFax(handle);
    }





}

