/****************************************************************************
 *
 * File:            TiffBitonalCompressionType.java
 *
 * Description:     TiffBitonalCompressionType Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image;

/**
 * <h1>The compression type for bitonal (Fax) TIFF images</h1>
 */
public enum TiffBitonalCompressionType  
{
    /**
     * <h1>CCITT Group 3</h1>
     * CCITT Group 3 is the predecessor to CCITT Group 4, it is a simpler
     * algorithm that normally results in a lower compression ratio.
     */
    G3(1),
    /**
     * <h1>CCITT Group 4</h1>
     * CCITT Group 4 is the standard compression for bitonal TIFF images
     * (i.e. facsimile).
     */
    G4(2);

    TiffBitonalCompressionType(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static TiffBitonalCompressionType fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return G3;
            case 2: return G4;
        }
        throw new IllegalArgumentException("Unknown value for TiffBitonalCompressionType: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
